//Demand Forecast Technique
//Under Quantitative Technique
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//Concept Information
//Time Series Analysis - Least Square Method
//y = a + b * x
//y indicates future sales
//x indicates the year number for which forecast is to be made
//a is the fixed element of overall sales which is not affected by time change
//b indicates the rate of change of sales with change in time
//a = Σy/N     b = Σxy/Σn^2

//Given
years = [2012,2013,2014,2015,2016]
sales = [120,130,135,142,138]     //in rupees

//Consider the year 2014
//Solution
X_val=[]
for i=1:5
    X_val($+1) = years(i)-years(3)
end

XY_val=[]
for i=1:5
    XY_val($+1) = X_val(i) * sales(i)
end

X_sqr=X_val^2

sigma_y = sum(sales)
sigma_x = sum(X_val)
sigma_xy = sum(XY_val)
sigma_xsqr = sum(X_sqr)

N=length(sales)
a = sigma_y/N
b = sigma_xy/sigma_xsqr

//Result
//Table
mprintf("Year            ")
for i=1:5
    mprintf("   %d",years(i))
end
mprintf("\n Sales(in rupees)")
for i=1:5
    mprintf("    %d",sales(i))
end

mprintf("\n\n Year\t  Sales(Y)   X     XY       X^2\n")
for i=1:5
    mprintf(" %d\t   %d\t     %d\t   %d\t     %d\n",years(i),sales(i),X_val(i),XY_val(i),X_sqr(i))
end

mprintf("\n\tΣy=%d\t  Σx=%d  Σxy=%d  Σx^2=%d\n",sigma_y,sigma_x,sigma_xy,sigma_xsqr)

mprintf("\n a = %d",a)
mprintf("\n b = %.2f",b)

//Future Sales Prediction
//For 2017
sigma_x = 2017 - 2014 //expected year - current case year
sigma_y = a + b * sigma_x
mprintf("\n\n Estimate : %.2f",sigma_y)

//For 2018
sigma_x = 2018 - 2014 //expected year - current case year
sigma_y = a + b * sigma_x
mprintf("\n Estimate : %.2f",sigma_y)

//Output
// Year               2012   2013   2014   2015   2016
// Sales(in rupees)    120    130    135    142    138
//
// Year	  Sales(Y)   X     XY       X^2
// 2012	   120	     -2	   -240	     4
// 2013	   130	     -1	   -130	     1
// 2014	   135	     0	   0	     0
// 2015	   142	     1	   142	     1
// 2016	   138	     2	   276	     4
//
//	Σy=665	  Σx=0  Σxy=48  Σx^2=10
//
// a = 133
// b = 4.80
//
// Estimate : 147.40
// Estimate : 152.20
